package com.ejie.ab04b.service;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.constantes.TipoCambio;
import com.ejie.ab04b.constantes.TipoExpedienteFolderEnum;
import com.ejie.ab04b.dao.ComunicacionAperturaCustomDao;
import com.ejie.ab04b.dao.CoordinadorObraDao;
import com.ejie.ab04b.dao.FolderDao;
import com.ejie.ab04b.dao.HistCambiosAperturasDao;
import com.ejie.ab04b.dao.NumeracionExpedienteDao;
import com.ejie.ab04b.dao.ObraDao;
import com.ejie.ab04b.dao.PromotorDao;
import com.ejie.ab04b.dao.ProyectistaDao;
import com.ejie.ab04b.dao.solicitud.SolicAperturasDao;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.Folder;
import com.ejie.ab04b.model.HistCambiosAperturas;
import com.ejie.ab04b.model.NumeracionExpediente;
import com.ejie.ab04b.model.Obra;
import com.ejie.ab04b.model.Promotor;
import com.ejie.ab04b.model.Proyectista;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.model.solicitud.SolicAperturas;
import com.ejie.ab04b.service.nora.LocalidadService;
import com.ejie.ab04b.service.nora.MunicipioService;
import com.ejie.ab04b.service.nora.ProvinciaService;
import com.ejie.ab04b.service.platea.ReeService;
import com.ejie.ab04b.util.HistCambiosAperturasUtil;
import com.ejie.ab04b.util.PropertiesUtil;
import com.ejie.ab04b.util.Utilities;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.webservice.client.documentowebservice.AlineacionCol;
import com.ejie.ab04b.webservice.client.documentowebservice.AlineacionZona;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionCab;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionCol;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionPag;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionPie;
import com.ejie.ab04b.webservice.client.documentowebservice.DocumentoWebServiceImpl;
import com.ejie.ab04b.webservice.client.documentowebservice.Elemento;
import com.ejie.ab04b.webservice.client.documentowebservice.Grupo;
import com.ejie.ab04b.webservice.client.documentowebservice.Modo;
import com.ejie.ab04b.webservice.client.documentowebservice.Orientacion;
import com.ejie.ab04b.webservice.client.documentowebservice.Tamano;
import com.ejie.ab04b.webservice.client.documentowebservice.Tipo;
import com.ejie.ab04b.webservice.client.documentowebservice.Zona;
import com.ejie.ct.xml.FolderDocumentList;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b56s00ServiceImpl generated by UDA, 26-dic-2016 13:08:26.
 * 
 * @author UDA
 */

@Service(value = "comunicAperturaService")
public class ComunicacionAperturaServiceImpl
		implements ComunicacionAperturaService {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionAperturaServiceImpl.class);

	@Autowired()
	private ComunicacionAperturaCustomDao comunicacionAperturaDao;
	@Autowired()
	private SolicAperturasDao solicAperturaDao;
	@Autowired()
	private ObraDao obraDao;
	@Autowired()
	private PromotorDao promotorDao;
	@Autowired()
	private ProyectistaDao proyectistaDao;
	@Autowired()
	private CoordinadorObraDao coordinadorDao;
	@Autowired()
	private FolderDao folderDao;

	@Autowired()
	private NumeracionExpedienteDao numeracionExpedienteDao;

	@Autowired()
	private DatosNotificacionService datosNotificacionService;

	@Autowired()
	private HistCambiosAperturasDao histCambiosAperturasDao;

	@Autowired()
	private ReeService reeService;

	@Autowired()
	private DatosLocalizacionService datosLocalizacionService;

	@Autowired()
	private DatosAvisoService datosAvisoService;

	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private DocumentoWebServiceImpl documentoWebServiceImpl;

	@Autowired()
	private LocalidadService localidadService;

	@Autowired()
	private ProvinciaService provinciaService;

	@Autowired()
	private MunicipioService municipioService;

	/**
	 * Inserts a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura add(ComunicacionApertura ab04b56s00) {
		return this.comunicacionAperturaDao.add(ab04b56s00);
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura update(ComunicacionApertura ab04b56s00) {
		return this.comunicacionAperturaDao.update(ab04b56s00);
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura updateFilled(ComunicacionApertura ab04b56s00) {
		return this.comunicacionAperturaDao.updateFilled(ab04b56s00);
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura updateCierre(ComunicacionApertura ab04b56s00) {
		return this.comunicacionAperturaDao.updateCierre(ab04b56s00);
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosTabProcAlmac(
			ComunicacionApertura ab04b56s00) {
		ComunicacionApertura ape = new ComunicacionApertura();

		// registrar historico cambios
		if (ab04b56s00.isHistorico()) {
			ComunicacionApertura comunicacionAperturaOld = this.comunicacionAperturaDao
					.find(ab04b56s00);
			String comunicacionAperturaOldStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Prod./Almac.",
							comunicacionAperturaOld);

			ape = this.comunicacionAperturaDao
					.modificarDatosTabProcAlmac(ab04b56s00);
			ComunicacionApertura comunicacionAperturaNew = this.comunicacionAperturaDao
					.find(ape);

			String comunicacionAperturaNewStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Prod./Almac.",
							comunicacionAperturaNew);

			if (!comunicacionAperturaNewStr
					.equals(comunicacionAperturaOldStr)) {
				HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
				histCambioAperturas
						.setIdape087(comunicacionAperturaOld.getIdape056());
				if (comunicacionAperturaOld.getMigrado056() != null
						&& Constantes.VALUE_SI.equals(
								comunicacionAperturaOld.getMigrado056())) {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
				} else {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
				}

				histCambioAperturas
						.setRegoriginal087(comunicacionAperturaOldStr);
				histCambioAperturas
						.setRegmidificaciones087(comunicacionAperturaNewStr);
				histCambioAperturas.setFecmodif087(new Date());
				histCambioAperturas.setTipocambio087(
						TipoCambio.MODIFICACION_APERTURA.getCodigo());

				this.histCambiosAperturasDao.add(histCambioAperturas);
			} else {
				ape = this.comunicacionAperturaDao
						.modificarDatosTabProcAlmac(ab04b56s00);
			}
		} else {
			ape = this.comunicacionAperturaDao
					.modificarDatosTabProcAlmac(ab04b56s00);
		}
		return ape;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00
	 * @param platea
	 *            boolean Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosTabNotificacion(
			ComunicacionApertura ab04b56s00, boolean platea) {

		ComunicacionApertura comunicacionAperturaOld = new ComunicacionApertura();
		String comunicacionAperturaOldStr = "";
		if (ab04b56s00.isHistorico()) {
			// registrar historico cambios
			comunicacionAperturaOld = this
					.findComunicAperturaConNotificacion(ab04b56s00);
			comunicacionAperturaOldStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Datos notificación.",
							comunicacionAperturaOld);
		}
		// Localización
		if (ab04b56s00.getDatosNotificacion() != null
				&& ab04b56s00.getDatosNotificacion().getCanalnotif066() != null
				&& ab04b56s00.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_POSTAL)
				&& !platea) {
			DatosLocalizacion localizacion = ab04b56s00.getDatosNotificacion()
					.getDatosLocalizacion();
			if (localizacion.getCodLocalizacion067() != null) {
				// Los datos de localización existen. Los actualizamos
				this.datosLocalizacionService.update(localizacion);
			} else {
				// Los datos de localización no existen. Los insertamos
				localizacion = this.datosLocalizacionService.add(localizacion);
				ab04b56s00.getDatosNotificacion()
						.setDatosLocalizacion(localizacion);

			}
		}

		// Datos notificación
		if (ab04b56s00.getDatosNotificacion() != null) {
			if (ab04b56s00.getDatosNotificacion().getCanalnotif066() != null
					&& !platea) {
				DatosLocalizacion datosLoc = ab04b56s00.getDatosNotificacion()
						.getDatosLocalizacion();
				if (ab04b56s00.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_TELEMATICO)) {
					ab04b56s00.getDatosNotificacion()
							.setDatosLocalizacion(new DatosLocalizacion(null));
				}

				// Los datos de notificación existen. Los actualizamos
				this.datosNotificacionService
						.update(ab04b56s00.getDatosNotificacion());
				if (ab04b56s00.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_TELEMATICO)) {
					this.datosLocalizacionService.remove(datosLoc);
				}

				ab04b56s00 = this.comunicacionAperturaDao
						.modificarDatosTabNotificacion(ab04b56s00);

			} else {
				// Los datos de notificación no existen. Los insertamos
				DatosNotificacion datosNotif = this.datosNotificacionService
						.add(ab04b56s00.getDatosNotificacion());
				ab04b56s00.setDatosNotificacion(datosNotif);
				ComunicacionApertura aperturaDatosNotif = new ComunicacionApertura();
				aperturaDatosNotif.setTerape056(ab04b56s00.getTerape056());
				aperturaDatosNotif.setAnoape056(ab04b56s00.getAnoape056());
				aperturaDatosNotif.setNumape056(ab04b56s00.getNumape056());

				aperturaDatosNotif.setDatosNotificacion(datosNotif);
				ab04b56s00 = this.comunicacionAperturaDao
						.modificarDatosTabNotificacion(ab04b56s00);
			}
		}

		ComunicacionApertura ape = new ComunicacionApertura();
		if (ab04b56s00.isHistorico()) {
			// registrar historico cambios
			ape = this.comunicacionAperturaDao
					.modificarDatosTabNotificacionContacto(ab04b56s00);
			ComunicacionApertura comunicacionAperturaNew = this
					.findComunicAperturaConNotificacion(ape);

			String comunicacionAperturaNewStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Datos notificación.",
							comunicacionAperturaNew);

			if (!comunicacionAperturaNewStr
					.equals(comunicacionAperturaOldStr)) {
				HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
				histCambioAperturas
						.setIdape087(comunicacionAperturaOld.getIdape056());
				if (comunicacionAperturaOld.getMigrado056() != null
						&& Constantes.VALUE_SI.equals(
								comunicacionAperturaOld.getMigrado056())) {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
				} else {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
				}

				histCambioAperturas
						.setRegoriginal087(comunicacionAperturaOldStr);
				histCambioAperturas
						.setRegmidificaciones087(comunicacionAperturaNewStr);
				histCambioAperturas.setFecmodif087(new Date());
				histCambioAperturas.setTipocambio087(
						TipoCambio.MODIFICACION_APERTURA.getCodigo());

				this.histCambiosAperturasDao.add(histCambioAperturas);
			} else {
				ape = this.comunicacionAperturaDao
						.modificarDatosTabNotificacionContacto(ab04b56s00);
			}
		} else {
			ape = this.comunicacionAperturaDao
					.modificarDatosTabNotificacionContacto(ab04b56s00);
		}

		return ape;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param apertura
	 *            ComunicacionApertura ComunicacionApertura
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosTabEstadoDoc(
			ComunicacionApertura apertura) {
		return this.comunicacionAperturaDao
				.modificarDatosTabEstadoDoc(apertura);
	}

	/**
	 * Busca los datos de registro.
	 * 
	 * @param apertura
	 *            ComunicacionApertura ComunicacionApertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findDatosRegistro(
			ComunicacionApertura apertura) {
		return this.comunicacionAperturaDao.findDatosRegistro(apertura);
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param apertura
	 *            ComunicacionApertura ComunicacionApertura
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosRegistro(
			ComunicacionApertura apertura) {
		return this.comunicacionAperturaDao.modificarDatosRegistro(apertura);
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosTabDatosObra(
			ComunicacionApertura ab04b56s00) {

		/*
		 * Obra obra = this.obraDao
		 * .modificarObraTabDatosObra(ab04b56s00.getObra());
		 * ab04b56s00.setObra(obra);
		 */

		ComunicacionApertura ape = new ComunicacionApertura();
		Obra obra = new Obra();

		if (ab04b56s00.isHistorico()) {
			// registrar historico cambios
			ComunicacionApertura comunicacionAperturaOld = this.comunicacionAperturaDao
					.find3(ab04b56s00);
			String comunicacionAperturaOldStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Obra", comunicacionAperturaOld);

			obra = this.obraDao.modificarObraTabDatosObra(ab04b56s00.getObra());
			ab04b56s00.setObra(obra);
			ab04b56s00.setFecfinplazo056(ab04b56s00.getObra().getFecfin082());
			comunicacionAperturaDao.updateFecFinPlazo(ab04b56s00);
			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosObra(ab04b56s00);

			ComunicacionApertura comunicacionAperturaNew = this.comunicacionAperturaDao
					.find3(ape);
			String comunicacionAperturaNewStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Obra", comunicacionAperturaNew);
			// Si no hay cambios no se generara una enytrada en el Historico
			if (!comunicacionAperturaNewStr
					.equals(comunicacionAperturaOldStr)) {
				// registrar historico cambios
				HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
				histCambioAperturas
						.setIdape087(comunicacionAperturaOld.getIdape056());
				if (comunicacionAperturaOld.getMigrado056() != null
						&& Constantes.VALUE_SI.equals(
								comunicacionAperturaOld.getMigrado056())) {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
				} else {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
				}

				histCambioAperturas
						.setRegoriginal087(comunicacionAperturaOldStr);
				histCambioAperturas
						.setRegmidificaciones087(comunicacionAperturaNewStr);
				histCambioAperturas.setFecmodif087(new Date());
				histCambioAperturas.setTipocambio087(
						TipoCambio.MODIFICACION_APERTURA.getCodigo());

				this.histCambiosAperturasDao.add(histCambioAperturas);
			} else {
				obra = this.obraDao
						.modificarObraTabDatosObra(ab04b56s00.getObra());
				ab04b56s00.setObra(obra);
				ab04b56s00
						.setFecfinplazo056(ab04b56s00.getObra().getFecfin082());
				comunicacionAperturaDao.updateFecFinPlazo(ab04b56s00);
				ape = this.comunicacionAperturaDao
						.modificarDatosTabDatosObra(ab04b56s00);
			}
		} else {
			obra = this.obraDao.modificarObraTabDatosObra(ab04b56s00.getObra());
			ab04b56s00.setObra(obra);
			ab04b56s00.setFecfinplazo056(ab04b56s00.getObra().getFecfin082());
			comunicacionAperturaDao.updateFecFinPlazo(ab04b56s00);
			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosObra(ab04b56s00);
		}

		return ape;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosTabDatosCentro(
			ComunicacionApertura ab04b56s00) {

		// registrar historico cambios
		ComunicacionApertura ape = new ComunicacionApertura();

		if (ab04b56s00.isHistorico()) {

			ComunicacionApertura comunicacionAperturaOld = this.comunicacionAperturaDao
					.find(ab04b56s00);
			String comunicacionAperturaOldStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Centro",
							comunicacionAperturaOld);

			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosCentro(ab04b56s00);
			ComunicacionApertura comunicacionAperturaNew = this.comunicacionAperturaDao
					.find(ape);

			String comunicacionAperturaNewStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Centro",
							comunicacionAperturaNew);

			if (!comunicacionAperturaNewStr
					.equals(comunicacionAperturaOldStr)) {
				HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
				histCambioAperturas
						.setIdape087(comunicacionAperturaOld.getIdape056());
				if (comunicacionAperturaOld.getMigrado056() != null
						&& Constantes.VALUE_SI.equals(
								comunicacionAperturaOld.getMigrado056())) {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
				} else {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
				}

				histCambioAperturas
						.setRegoriginal087(comunicacionAperturaOldStr);
				histCambioAperturas
						.setRegmidificaciones087(comunicacionAperturaNewStr);
				histCambioAperturas.setFecmodif087(new Date());
				histCambioAperturas.setTipocambio087(
						TipoCambio.MODIFICACION_APERTURA.getCodigo());

				this.histCambiosAperturasDao.add(histCambioAperturas);
			} else {
				ape = this.comunicacionAperturaDao
						.modificarDatosTabDatosCentro(ab04b56s00);
			}
		} else {
			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosCentro(ab04b56s00);
		}

		return ape;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosTabDatosCentroAsignado(
			ComunicacionApertura ab04b56s00) {

		// registrar historico cambios
		ComunicacionApertura ape = new ComunicacionApertura();

		if (ab04b56s00.isHistorico()) {

			ComunicacionApertura comunicacionAperturaOld = this.comunicacionAperturaDao
					.find(ab04b56s00);
			String comunicacionAperturaOldStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Centro",
							comunicacionAperturaOld);

			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosCentroAsignado(ab04b56s00);
			ComunicacionApertura comunicacionAperturaNew = this.comunicacionAperturaDao
					.find(ape);

			String comunicacionAperturaNewStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Centro",
							comunicacionAperturaNew);

			if (!comunicacionAperturaNewStr
					.equals(comunicacionAperturaOldStr)) {
				HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
				histCambioAperturas
						.setIdape087(comunicacionAperturaOld.getIdape056());
				if (comunicacionAperturaOld.getMigrado056() != null
						&& Constantes.VALUE_SI.equals(
								comunicacionAperturaOld.getMigrado056())) {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
				} else {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
				}

				histCambioAperturas
						.setRegoriginal087(comunicacionAperturaOldStr);
				histCambioAperturas
						.setRegmidificaciones087(comunicacionAperturaNewStr);
				histCambioAperturas.setFecmodif087(new Date());
				histCambioAperturas.setTipocambio087(
						TipoCambio.MODIFICACION_APERTURA.getCodigo());

				this.histCambiosAperturasDao.add(histCambioAperturas);
			} else {
				ape = this.comunicacionAperturaDao
						.modificarDatosTabDatosCentroAsignado(ab04b56s00);
			}
		} else {
			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosCentroAsignado(ab04b56s00);
		}

		return ape;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosVisitaOsalan(
			ComunicacionApertura ab04b56s00) {
		ComunicacionApertura ape = new ComunicacionApertura();

		// registrar historico cambios
		if (ab04b56s00.isHistorico()) {
			ComunicacionApertura comunicacionAperturaOld = this.comunicacionAperturaDao
					.find(ab04b56s00);
			String comunicacionAperturaOldStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Centro",
							comunicacionAperturaOld);

			ape = this.comunicacionAperturaDao
					.modificarDatosVisitaOsalan(ab04b56s00);
			ComunicacionApertura comunicacionAperturaNew = this.comunicacionAperturaDao
					.find(ape);

			String comunicacionAperturaNewStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Centro",
							comunicacionAperturaNew);

			if (!comunicacionAperturaNewStr
					.equals(comunicacionAperturaOldStr)) {
				HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
				histCambioAperturas
						.setIdape087(comunicacionAperturaOld.getIdape056());
				if (comunicacionAperturaOld.getMigrado056() != null
						&& Constantes.VALUE_SI.equals(
								comunicacionAperturaOld.getMigrado056())) {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
				} else {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
				}

				histCambioAperturas
						.setRegoriginal087(comunicacionAperturaOldStr);
				histCambioAperturas
						.setRegmidificaciones087(comunicacionAperturaNewStr);
				histCambioAperturas.setFecmodif087(new Date());
				histCambioAperturas.setTipocambio087(
						TipoCambio.MODIFICACION_APERTURA.getCodigo());

				this.histCambiosAperturasDao.add(histCambioAperturas);
			} else {
				ape = this.comunicacionAperturaDao
						.modificarDatosVisitaOsalan(ab04b56s00);
			}
		} else {
			ape = this.comunicacionAperturaDao
					.modificarDatosVisitaOsalan(ab04b56s00);
		}
		return ape;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionApertura modificarDatosTabDatosEmpresa(
			ComunicacionApertura ab04b56s00) {

		// registrar historico cambios
		ComunicacionApertura ape = new ComunicacionApertura();

		if (ab04b56s00.isHistorico()) {
			ComunicacionApertura comunicacionAperturaOld = this.comunicacionAperturaDao
					.find(ab04b56s00);
			String comunicacionAperturaOldStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Empresa",
							comunicacionAperturaOld);

			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosEmpresa(ab04b56s00);
			ComunicacionApertura comunicacionAperturaNew = this.comunicacionAperturaDao
					.find(ab04b56s00);

			String comunicacionAperturaNewStr = HistCambiosAperturasUtil
					.concatenarCamposApertura("Empresa",
							comunicacionAperturaNew);
			if (!comunicacionAperturaNewStr
					.equals(comunicacionAperturaOldStr)) {
				HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
				histCambioAperturas
						.setIdape087(comunicacionAperturaOld.getIdape056());
				if (comunicacionAperturaOld.getMigrado056() != null
						&& Constantes.VALUE_SI.equals(
								comunicacionAperturaOld.getMigrado056())) {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
				} else {
					histCambioAperturas
							.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
				}

				histCambioAperturas
						.setRegoriginal087(comunicacionAperturaOldStr);
				histCambioAperturas
						.setRegmidificaciones087(comunicacionAperturaNewStr);
				histCambioAperturas.setFecmodif087(new Date());
				histCambioAperturas.setTipocambio087(
						TipoCambio.MODIFICACION_APERTURA.getCodigo());

				this.histCambiosAperturasDao.add(histCambioAperturas);
			} else {
				ape = this.comunicacionAperturaDao
						.modificarDatosTabDatosEmpresa(ab04b56s00);
			}

		} else {
			ape = this.comunicacionAperturaDao
					.modificarDatosTabDatosEmpresa(ab04b56s00);
		}
		return ape;
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura find(ComunicacionApertura ab04b56s00) {
		return (ComunicacionApertura) this.comunicacionAperturaDao
				.find(ab04b56s00);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura vFind(ComunicacionApertura ab04b56s00) {
		return (ComunicacionApertura) this.comunicacionAperturaDao
				.vFind(ab04b56s00);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura vFindDetalle(ComunicacionApertura ab04b56s00) {
		return (ComunicacionApertura) this.comunicacionAperturaDao
				.vFindDetalle(ab04b56s00);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param comunicApertura
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param filtro
	 *            ComunicacionApertura Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findDetalle(
			ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto, ComunicacionApertura filtro) {

		ComunicacionApertura comunicApe = this.comunicacionAperturaDao
				.vistaFindDetalle(comunicApertura, jqGridRequestDto, filtro);

		if (comunicApe.getCodobra056() != null) {
			Obra obraFind = new Obra();
			obraFind.setAnoexp082(comunicApe.getAnoape056());
			obraFind.setTerexp082(comunicApe.getTerape056());
			obraFind.setNumexp082(comunicApe.getNumape056().intValue());
			obraFind.setCodobra082(comunicApe.getCodobra056());

			Obra obraApertura = this.obraDao.findByExpediente(obraFind);

			comunicApe.setObra(obraApertura);
		}

		return comunicApe;
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00 Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findConObra(ComunicacionApertura ab04b56s00) {
		ComunicacionApertura comunicApe = (ComunicacionApertura) this.comunicacionAperturaDao
				.find(ab04b56s00);

		if (comunicApe.getCodobra056() != null) {
			Obra obraFind = new Obra();
			obraFind.setAnoexp082(comunicApe.getAnoape056());
			obraFind.setTerexp082(comunicApe.getTerape056());
			obraFind.setNumexp082(comunicApe.getNumape056().intValue());
			obraFind.setCodobra082(comunicApe.getCodobra056());

			Obra obraApertura = this.obraDao.findByExpediente(obraFind);

			comunicApe.setObra(obraApertura);
		}

		return comunicApe;

	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param folderId
	 *            String Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findByFolderId(String folderId) {
		return (ComunicacionApertura) this.comunicacionAperturaDao
				.findByFolderId(folderId);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param folderId
	 *            String Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findByFolderId2(String folderId) {
		return (ComunicacionApertura) this.comunicacionAperturaDao
				.findByFolderId2(folderId);
	}

	/**
	 * Deletes a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ComunicacionApertura ab04b56s00) {
		this.comunicacionAperturaDao.remove(ab04b56s00);
	}

	/**
	 * Finds a list of rows in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto List<Ab04b56s00>
	 * @return the list
	 */
	public List<ComunicacionApertura> findAll(ComunicacionApertura ab04b56s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<ComunicacionApertura>) this.comunicacionAperturaDao
				.findAll(ab04b56s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean List<Ab04b56s00>
	 * @return the list
	 */
	public List<ComunicacionApertura> findAllLike(
			ComunicacionApertura ab04b56s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<ComunicacionApertura>) this.comunicacionAperturaDao
				.vistaFindAllLike(ab04b56s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b56s00 table.
	 * 
	 * @param filterAb04b56s00
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(ComunicacionApertura filterAb04b56s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.comunicacionAperturaDao.removeMultiple(filterAb04b56s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filterAb04b56s00
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filter(
			ComunicacionApertura filterAb04b56s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<ComunicacionApertura> listaAb04b56s00 = this.comunicacionAperturaDao
				.vistaFindAllLike(filterAb04b56s00, jqGridRequestDto, false);
		Long recordNum = this.comunicacionAperturaDao
				.vistaFindAllLikeCount(filterAb04b56s00 != null
						? filterAb04b56s00 : new ComunicacionApertura(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<ComunicacionApertura>> reorderSelection = this.comunicacionAperturaDao
					.reorderSelection(filterAb04b56s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
					recordNum, listaAb04b56s00, reorderSelection);
		}
		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, listaAb04b56s00);
	}

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean JQGridResponseDto<ComunicacionApertura>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoAperturas(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		List<ComunicacionApertura> listaAperturas = this.comunicacionAperturaDao
				.listadoFindAllLike(filtro, jqGridRequestDto, false);
		Long recordNum = this.comunicacionAperturaDao.listadoFindAllLikeCount(
				filtro != null ? filtro : new ComunicacionApertura(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<ComunicacionApertura>> reorderSelection = this.comunicacionAperturaDao
					.reorderSelection(filtro, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
					recordNum, listaAperturas, reorderSelection);
		}
		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, listaAperturas);
	}

	/**
	 * Searches rows in the Ab04b56s00 table.
	 * 
	 * @param filterAb04b56s00
	 *            Ab04b56s00
	 * @param searchAb04b56s00
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean List<TableRowDto<Ab04b56s00>>
	 * @return the list
	 */
	public List<TableRowDto<ComunicacionApertura>> search(
			ComunicacionApertura filterAb04b56s00,
			ComunicacionApertura searchAb04b56s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.comunicacionAperturaDao.search(filterAb04b56s00,
				searchAb04b56s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b56s00 table.
	 * 
	 * @param filterAb04b56s00
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean Object
	 * @return the object
	 */
	public Object reorderSelection(ComunicacionApertura filterAb04b56s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.comunicacionAperturaDao.reorderSelection(filterAb04b56s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            ComunicacionApertura Ab04b56s00
	 * @return the list
	 */
	public List<ComunicacionApertura> findEmpresaObra(
			ComunicacionApertura ab04b56s00) {
		return this.comunicacionAperturaDao.findEmpresaObra(ab04b56s00);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            ComunicacionApertura Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura findComunicAperturaConNotificacion(
			ComunicacionApertura ab04b56s00) {

		ComunicacionApertura comunicacionApertura = this.comunicacionAperturaDao
				.vFindDetalle(ab04b56s00);

		// miramos si es la primera vez que se consulta y aun no tiene guardados
		// los datos de notificacion
		if (comunicacionApertura.getDatosNotificacion() == null
				|| comunicacionApertura.getDatosNotificacion()
						.getCodDatosNotif066() == null
				|| comunicacionApertura.getDatosNotificacion()
						.getCodDatosNotif066() == 0) {
			DatosNotificacion datosNotifFolderId = this.reeService
					.obtenerDatosNotificacionExpedienteREE(
							comunicacionApertura.getFolderId056(),
							(Constantes.VALUE_SI.equals(
									comunicacionApertura.getMigrado056())));

			if (datosNotifFolderId != null) {
				try {
					// los volcamos a nuestra bd

					comunicacionApertura
							.setDatosNotificacion(new DatosNotificacion());
					comunicacionApertura.getDatosNotificacion()
							.setCanalnotif066(
									datosNotifFolderId.getCanalnotif066());
					if (Constantes.LOCALE_ES
							.equals(LocaleContextHolder.getLocale())) {
						comunicacionApertura.getDatosNotificacion()
								.setIdioma066(
										Constantes.IDIOMA_NOTIF_CASTELLANO);
					} else if (Constantes.LOCALE_EU
							.equals(LocaleContextHolder.getLocale())) {
						comunicacionApertura.getDatosNotificacion()
								.setIdioma066(Constantes.IDIOMA_NOTIF_EUSKERA);
					}

					if (Constantes.CANAL_NOTIF_POSTAL
							.equals(datosNotifFolderId.getCanalnotif066())) {
						DatosLocalizacion dl = datosNotifFolderId
								.getDatosLocalizacion();

						Provincia prov = dl.getProvincia();
						Municipio mun = dl.getMunicipio();

						if (dl.getLocalidad().getCodLocalidad() == null) {

							if (dl.getProvincia().getDescripcion() != null) {
								prov = provinciaService
										.findAllFirst(new Provincia(null,
												dl.getProvincia()
														.getDescripcion(),
												null));
							}

							if (dl.getMunicipio().getDescripcion() != null
									&& prov != null) {
								mun = municipioService.findAllFirst(
										new Municipio(prov.getCodProvincia(),
												null, dl.getMunicipio()
														.getDescripcion()));
							}

							dl.setProvincia(prov);
							dl.setMunicipio(mun);
							if (prov != null && mun != null) {
								Localidad loc = localidadService.findAllFirst(
										new Localidad(prov.getCodProvincia(),
												mun.getCodMunicipio(), null,
												dl.getLocalidad()
														.getDescripcion()));

								Localidad fin = dl.getLocalidad();
								if (loc != null) {
									fin.setCodLocalidad(loc.getCodLocalidad());
								}
								dl.setLocalidad(fin);
							}
						}

						dl = datosLocalizacionService.add(dl);

						comunicacionApertura.getDatosNotificacion()
								.setDatosLocalizacion(dl);
					}

					// Los datos de notificación no existen. Los insertamos
					DatosNotificacion datosNotif = this.datosNotificacionService
							.add(comunicacionApertura.getDatosNotificacion());
					comunicacionApertura.setDatosNotificacion(datosNotif);

					comunicacionApertura.setHistorico(false);

					comunicacionApertura = this.modificarDatosTabNotificacion(
							comunicacionApertura, true);

					if (Constantes.CANAL_NOTIF_TELEMATICO
							.equals(datosNotifFolderId.getCanalnotif066())) {
						for (DatosAviso da : datosNotifFolderId
								.getListaDatosAviso()) {
							da.setDatosNotificacion(comunicacionApertura
									.getDatosNotificacion());
							da = datosAvisoService.add(da);
						}
					}
				} catch (Exception e) {
					ComunicacionAperturaServiceImpl.logger.error(
							"ERROR en findComunicAperturaConNotificacion", e);
				}
			}
		} else {
			DatosNotificacion datosNotificacionYAviso = this.datosNotificacionService
					.findConLocalizacionYAvisos(
							comunicacionApertura.getDatosNotificacion());

			if (datosNotificacionYAviso != null) {
				comunicacionApertura
						.setDatosNotificacion(datosNotificacionYAviso);
			}

			if (comunicacionApertura.getDatosNotificacion()
					.getDatosLocalizacion() == null) {
				comunicacionApertura.getDatosNotificacion()
						.setDatosLocalizacion(new DatosLocalizacion());
			}
		}

		return comunicacionApertura;
	}

	/**
	 * Crear una Comunicacion de Aperturas a partir del ContextSubmission.
	 * 
	 * @param contextSubmission
	 *            ContextSubmissionEvent ComunicacionApertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura insertarComunicacionAperturaContextSubmission(
			ContextSubmissionEvent contextSubmission) {

		// Utilizaremos el num. de registro para identificar la solicitud a
		// volcar
		String numRegistro = contextSubmission.getRegistryNumber();
		String folderId = contextSubmission.getFolderID();

		SolicAperturas solicitud = this.solicAperturaDao
				.findSolicitud(numRegistro);

		ComunicacionApertura apertura = new ComunicacionApertura();
		apertura.setAnoape056(new SimpleDateFormat(Constantes.DATE_PATTERN_YEAR)
				.format(new Date()));

		apertura.setNumReg(numRegistro);

		String terape = "";
		if (Constantes.VALUE_SI.equals(apertura.getIndobra056())) {
			// Es de tipo obra
			terape = apertura.getObra().getPrvobr082();
		} else {
			// Es de tipo centro de trabajo
			terape = solicitud.getPrvctr056().getCodProvincia();
		}
		apertura.setTerape056(terape);

		NumeracionExpediente numApe = new NumeracionExpediente();
		numApe.setTerexp075(apertura.getTerape056());
		numApe.setAnoexp075(apertura.getAnoape056());
		numApe.setTipexp075(TipoExpedienteFolderEnum.APERTURA
				.getIdTipoExpediente().toString());

		// obtenemos el numero de apertura
		apertura.setNumape056(
				this.numeracionExpedienteDao.obtenerNumExpSiguiente(numApe));

		// Realizamos las inserciones en orden

		// Creamos e insertamos los datos de notificación
		DatosNotificacion datosNotificacion = this.datosNotificacionService
				.insertarDatosNotificacionContextSubmission(contextSubmission);
		// Los relacionamos a la apertura
		apertura.setDatosNotificacion(datosNotificacion);

		apertura.setFolderId056(folderId);
		// Añadimos la apertura
		apertura = this.comunicacionAperturaDao
				.addFromSolicitudNumReg(apertura);

		if (Constantes.VALUE_SI.equals(solicitud.getIndobra056())) {
			Obra obra = new Obra();
			obra.setAnoexp082(apertura.getAnoape056());
			obra.setNumexp082(apertura.getNumape056().intValue());
			obra.setTerexp082(apertura.getTerape056());
			// Si es de obra, insertamos la obra
			apertura.setObra(
					this.obraDao.addFromSolicitud(obra, solicitud.getObra()));
			apertura.setCodobra056(apertura.getObra().getCodobra082());
			// }

			// Relacionamos la obra con la apertura
			if (apertura.getCodobra056() != null) {
				this.comunicacionAperturaDao.updateCodObra(apertura);
			}

			// if (Constantes.VALUE_SI.equals(solicitud.getIndobra056())) {
			// Relacionamos e insertamos promotores
			Promotor promotor = new Promotor();
			promotor.setAnoexp085(apertura.getAnoape056());
			promotor.setTerexp085(apertura.getTerape056());
			promotor.setNumexp085(apertura.getNumape056().intValue());
			promotor.setCodobra085(apertura.getObra().getCodobra082());
			promotor.setApertura(apertura);
			this.promotorDao.addFromSolicitud(promotor);

			// PROYECTISTAS
			Proyectista proyectista = new Proyectista();
			proyectista.setAnoexp083(apertura.getAnoape056());
			proyectista.setTerexp083(apertura.getTerape056());
			proyectista.setNumexp083(apertura.getNumape056().intValue());
			proyectista.setCodobra083(apertura.getObra().getCodobra082());
			proyectista.setApertura(apertura);
			this.proyectistaDao.addFromSolicitud(proyectista);

			// Relacionamos e insertamos coordinadores
			CoordinadorObra coordinador = new CoordinadorObra();
			coordinador.setAnoexp084(apertura.getAnoape056());
			coordinador.setNumexp084(apertura.getNumape056().intValue());
			coordinador.setTerexp084(apertura.getTerape056());
			coordinador.setCodobra084(apertura.getObra().getCodobra082());
			coordinador.setApertura(apertura);
			this.coordinadorDao.addFromSolicitud(coordinador);
		}

		Folder folder = new Folder();
		folder.setAnoexp077(apertura.getAnoape056());
		folder.setTerexp077(apertura.getTerape056());
		folder.setNumexp077(apertura.getNumape056().intValue());
		folder.setFolderid077(contextSubmission.getFolderID());
		folder.setTipexp077(String.valueOf(
				TipoExpedienteFolderEnum.APERTURA.getIdTipoExpediente()));
		this.folderDao.add(folder);

		apertura.setFolderId056(folder.getFolderid077());

		// enlazar solicitud con expediente apertura
		solicitud.setTerape056(apertura.getTerape056());
		solicitud.setNumape056(apertura.getNumape056().intValue());
		solicitud.setAnoape056(apertura.getAnoape056());
		this.solicAperturaDao.updateDatosApe(solicitud);

		return apertura;

	}

	/**
	 * Crea un registro con los datos minimos.
	 * 
	 * ComunicacionApertura
	 * 
	 * @param ape
	 *            the ape
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura altaComunicacionAperturaPresencial(
			ComunicacionApertura ape) {

		ComunicacionApertura apertura = new ComunicacionApertura();
		List<ErrorField> errores = new ArrayList<ErrorField>();

		if (ape.getDeseaRegistrar() != null) {
			if ("S".equals(ape.getDeseaRegistrar())) {
				apertura.setDeseaRegistrar(ape.getDeseaRegistrar());
				apertura.setNumReg("");
				apertura.setFecReg(null);
			} else if ("N".equals(ape.getDeseaRegistrar())) {
				apertura.setDeseaRegistrar(ape.getDeseaRegistrar());
				if (ape.getNumReg() != null) {
					apertura.setNumReg(ape.getNumReg());
				} else {
					apertura.setNumReg("");
					errores.add(new ErrorField("aperturas.detalle.numReg",
							"validacion.obligatorio"));
				}
				if (ape.getFecReg() != null) {
					apertura.setFecReg(ape.getFecReg());
				} else {
					apertura.setFecReg(null);
					errores.add(new ErrorField("aperturas.detalle.fecReg",
							"validacion.obligatorio"));
				}
			}
		} else {
			apertura.setNumReg("");
			apertura.setFecReg(null);
			errores.add(new ErrorField("aperturas.detalle.deseaRegistrar",
					"validacion.obligatorio"));
		}

		if (ape.getTipdoc056() != null) {
			apertura.setTipdoc056(ape.getTipdoc056());
		} else {
			errores.add(new ErrorField("aperturas.tipoidentif",
					"validacion.obligatorio"));
		}
		if (ape.getNumdoc056() != null) {
			apertura.setNumdoc056(ape.getNumdoc056());
		} else {
			errores.add(new ErrorField("aperturas.numdoc",
					"validacion.obligatorio"));
		}
		if (ape.getNomemp056() != null) {
			apertura.setNomemp056(ape.getNomemp056());
		} else {
			errores.add(new ErrorField("aperturas.nombreEmpresa",
					"validacion.obligatorio"));
		}

		if (ape.getIndobra056() != null) {
			apertura.setIndobra056(ape.getIndobra056());
		} else {
			errores.add(new ErrorField("aperturas.detalle.indobra",
					"validacion.obligatorio"));
		}
		if (ape.getNueva056() != null) {
			apertura.setNueva056(ape.getNueva056());
		}

		if (ape.getPaisemp056() != null) {
			apertura.setPaisemp056(ape.getPaisemp056());
		} else {
			apertura.setPaisemp056("");
		}
		if (ape.getProvinciaEmp() != null
				&& ape.getProvinciaEmp().getCodProvincia() != null) {
			apertura.setProvinciaEmp(
					new Provincia(ape.getProvinciaEmp().getCodProvincia()));
		} else {
			apertura.setProvinciaEmp(new Provincia());
		}
		if (ape.getMunicipioEmp() != null
				&& ape.getMunicipioEmp().getCodMunicipio() != null) {
			apertura.setMunicipioEmp(
					new Municipio(ape.getMunicipioEmp().getCodMunicipio()));
		} else {
			apertura.setMunicipioEmp(new Municipio());
		}
		if (ape.getDmunemp056() != null) {
			apertura.setDmunemp056(ape.getDmunemp056());
		} else {
			apertura.setDmunemp056("");
		}
		if (ape.getDiremp056() != null) {
			apertura.setDiremp056(ape.getDiremp056());
		} else {
			apertura.setDiremp056("");
		}
		if (ape.getCpoemp056() != null) {
			apertura.setCpoemp056(ape.getCpoemp056());
		} else {
			apertura.setCpoemp056("");
		}
		if (ape.getTlfemp056() != null) {
			apertura.setTlfemp056(ape.getTlfemp056());
		} else {
			apertura.setTlfemp056("");
		}
		if (ape.getCnaeemp056() != null) {
			apertura.setCnaeemp056(ape.getCnaeemp056());
		} else {
			apertura.setCnaeemp056("");
		}
		if (ape.getCodentiat056() != null) {
			apertura.setCodentiat056(ape.getCodentiat056());
		} else {
			apertura.setCodentiat056("");
		}
		if (ape.getEntiat056() != null) {
			apertura.setEntiat056(ape.getEntiat056());
		} else {
			apertura.setEntiat056("");
		}

		if (ape.getAnoape056() == null) {
			apertura.setAnoape056(
					new SimpleDateFormat(Constantes.DATE_PATTERN_YEAR)
							.format(new Date()));
		} else {
			apertura.setAnoape056(ape.getAnoape056());
		}

		if (ape.getTerape056() == null) {
			apertura.setTerape056(
					UtilSeguridad.getInstance().obtenerDelegacionUsuario());
		} else {
			apertura.setTerape056(ape.getTerape056());
		}

		NumeracionExpediente numApe = null;
		boolean existe = false;
		ComunicacionApertura aperturaAux = new ComunicacionApertura();
		if (ape.getNumape056() != null) {
			apertura.setNumape056(ape.getNumape056());
			aperturaAux.setTerape056(apertura.getTerape056());
			aperturaAux.setAnoape056(apertura.getAnoape056());
			aperturaAux.setNumape056(apertura.getNumape056());
			existe = this.comunicacionAperturaDao.findAllCount(aperturaAux) > 0;
			if (existe) {
				errores.add(0,
						new ErrorField("aperturas.nexp", "error.existenumape"));

				if (!errores.isEmpty()) {
					throw new ErrorGenericoException(errores);
				}
			}
		} else if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		} else {
			boolean libre = false;
			while (!libre) {
				numApe = new NumeracionExpediente();
				numApe.setTerexp075(apertura.getTerape056());
				numApe.setAnoexp075(apertura.getAnoape056());
				numApe.setTipexp075(TipoExpedienteFolderEnum.APERTURA
						.getIdTipoExpediente().toString());

				// obtenemos el numero de apertura
				apertura.setNumape056(this.numeracionExpedienteDao
						.obtenerNumExpSiguiente(numApe));

				aperturaAux.setTerape056(apertura.getTerape056());
				aperturaAux.setAnoape056(apertura.getAnoape056());
				aperturaAux.setNumape056(apertura.getNumape056());
				if (this.comunicacionAperturaDao
						.findAllCount(aperturaAux) == 0) {
					libre = true;
				} else {
					// actualizar numero de apertura
					this.numeracionExpedienteDao
							.actualizarNumExpSiguiente(numApe);
				}
			}

		}
		// Realizamos las inserciones en orden

		// Añadimos la apertura
		apertura = this.comunicacionAperturaDao.addPresencial(apertura);

		Obra obra = new Obra();
		obra.setAnoexp082(apertura.getAnoape056());
		obra.setNumexp082(apertura.getNumape056().intValue());
		obra.setTerexp082(apertura.getTerape056());
		// Si es de obra, insertamos la obra
		apertura.setObra(this.obraDao.addPresencial(obra));
		apertura.setCodobra056(apertura.getObra().getCodobra082());

		// Relacionamos la obra con la apertura
		if (apertura.getCodobra056() != null) {
			this.comunicacionAperturaDao.updateCodObra(apertura);
		}

		apertura.setDatosNotificacion(new DatosNotificacion());
		apertura.getDatosNotificacion()
				.setCanalnotif066(Constantes.CANAL_NOTIF_TELEMATICO);
		if (Constantes.LOCALE_ES.equals(LocaleContextHolder.getLocale())) {
			apertura.getDatosNotificacion()
					.setIdioma066(Constantes.IDIOMA_NOTIF_CASTELLANO);
		} else if (Constantes.LOCALE_EU
				.equals(LocaleContextHolder.getLocale())) {
			apertura.getDatosNotificacion()
					.setIdioma066(Constantes.IDIOMA_NOTIF_EUSKERA);
		}
		apertura.getDatosNotificacion()
				.setDatosLocalizacion(new DatosLocalizacion());

		// Los datos de notificación no existen. Los insertamos
		DatosNotificacion datosNotif = this.datosNotificacionService
				.add(apertura.getDatosNotificacion());
		apertura.setDatosNotificacion(datosNotif);

		this.comunicacionAperturaDao.modificarDatosTabNotificacion(apertura);

		if (ape.getNumape056() == null) {
			// actualizar numero de apertura
			this.numeracionExpedienteDao.actualizarNumExpSiguiente(numApe);
		}

		return apertura;

	}

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoComunicacionAperturasPDF(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto)
			throws AB04BException {
		try {
			String informe = "";
			SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.listadoFindAllLike(filtro, jqGridRequestDto, false);

			if (!listadoEstadistica.isEmpty()) {

				for (int i = 0; i < listadoEstadistica.size(); i++) {

					hmDatosFila = this.inicializarHmDatosFila();

					hmDatosFila.put("nExpediente",
							listadoEstadistica.get(i).getTerape056() + "-"
									+ listadoEstadistica.get(i).getAnoape056()
									+ "-"
									+ listadoEstadistica.get(i).getNumape056());
					hmDatosFila.put("obra",
							Constantes.VALUE_SI.equals(
									listadoEstadistica.get(i).getIndobra056())
											? Constantes.TOOLKIT_SI
											: Constantes.TOOLKIT_NO);
					hmDatosFila.put("fecpre",
							listadoEstadistica.get(i).getFecpre056() != null
									? formatter.format(listadoEstadistica.get(i)
											.getFecpre056())
									: "");
					hmDatosFila.put("cifnif",
							listadoEstadistica.get(i).getNumdoc056());
					hmDatosFila.put("razonSocial",
							listadoEstadistica.get(i).getNomctr056());
					hmDatosFila.put("dirCentro",
							listadoEstadistica.get(i).getDirctr056());
					hmDatosFila.put("actCtr",
							listadoEstadistica.get(i).getCnaectr056());
					hmDatosFila.put("visosl",
							listadoEstadistica.get(i).getDescVisosl());

					hmDatos.add(hmDatosFila);
				}
			}

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoDetalleAperturas", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(new Grupo(
					this.obtenerListaComunicacionAperturasPDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtener lista comunicacion aperturas PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListaComunicacionAperturasPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.expediente", null,
						locale),
				"nExpediente", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.obra", null, locale),
				"obra", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.fecpre", null, locale),
				"fecpre", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numdoc", null, locale),
				"cifnif", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.nomemp", null, locale),
				"razonSocial", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.dirctr", null, locale),
				"dirCentro", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.actCtr", null, locale),
				"actCtr", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.visita", null, locale),
				"visosl", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param b
	 *            Boolean String
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoAperturasNum(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b) {
		ComunicacionApertura apertura = new ComunicacionApertura();
		apertura.setTerape056(filtro.getTerape056());
		apertura.setTerapeDesc(
				Utilities.getInstance().strTerritorio(filtro.getTerape056()));
		Long recordNum = this.comunicacionAperturaDao
				.listadoFindAllLikeCount(filtro, false);
		apertura.setNumAperturas(recordNum.toString());
		List<ComunicacionApertura> lista = new ArrayList<ComunicacionApertura>();
		lista.add(apertura);
		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * Filter method in the ComunicacionApertura table.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoComunicacionAperturasNumPDF(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto)
			throws AB04BException {
		try {
			String informe = "";
			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			ComunicacionApertura apertura = new ComunicacionApertura();
			apertura.setTerape056(filtro.getTerape056());
			apertura.setTerapeDesc(Utilities.getInstance()
					.strTerritorio(filtro.getTerape056()));
			Long recordNum = this.comunicacionAperturaDao
					.listadoFindAllLikeCount(filtro, false);
			apertura.setNumAperturas(recordNum.toString());
			List<ComunicacionApertura> listado = new ArrayList<ComunicacionApertura>();
			listado.add(apertura);

			// if (!listado.isEmpty()) {

			for (int i = 0; i < listado.size(); i++) {

				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("territorio", listado.get(i).getTerapeDesc());
				hmDatosFila.put("numAperturas",
						listado.get(i).getNumAperturas());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoDetalleAperturas", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(new Grupo(
					this.obtenerListaComunicacionAperturasNumPDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtener lista comunicacion aperturas num PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListaComunicacionAperturasNumPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.territorio", null,
						locale),
				"territorio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturas", null,
						locale),
				"numAperturas", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoAnualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		List<ComunicacionApertura> lista = this.comunicacionAperturaDao
				.findListadoAnualMesTer(filtro, jqGridRequestDto, false);

		Long recordNum = this.comunicacionAperturaDao
				.findListadoAnualMesTerCount(
						filtro != null ? filtro : new ComunicacionApertura(),
						false);

		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoAnualMesTerPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoAnualMesTerPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findListadoAnualMesTer(filtro, jqGridRequestDto, false);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {

				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("mes", listadoEstadistica.get(i).getMes());
				hmDatosFila.put("territorio",
						listadoEstadistica.get(i).getTerapeDesc());
				hmDatosFila.put("numaperturas",
						listadoEstadistica.get(i).getNumAperturas());
				hmDatosFila.put("porcentaje",
						listadoEstadistica.get(i).getPorcentaje());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoAnualMesTer", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(new Grupo(this.obtenerListaColumnasAnualMesTerPDF(),
					"GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Obtener lista columnas anual mes ter PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListaColumnasAnualMesTerPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.mes", null, locale),
				"mes", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.territorio", null,
						locale),
				"territorio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturas", null,
						locale),
				"numaperturas", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.porcentaje", null,
						locale),
				"porcentaje", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoBianualMesTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		List<ComunicacionApertura> lista = this.comunicacionAperturaDao
				.findListadoBianualMesTer(filtro, jqGridRequestDto, false);

		// El listado tendra 36 resgistros si no se filtra por territorio (12
		// meses * 3 territorios) y 12 registros si se filtra por territorio
		Long recordNum = ConstantesNum.LONG_36;
		if (filtro.getTerape056() != null) {
			recordNum = ConstantesNum.LONG_12;
		}

		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoAnualMesTerPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoBianualMesTerPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findListadoBianualMesTer(filtro, jqGridRequestDto, false);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {

				hmDatosFila = this.inicializarHmDatosFila();
				hmDatosFila.put("mes", listadoEstadistica.get(i).getMes());
				hmDatosFila.put("territorio",
						listadoEstadistica.get(i).getTerapeDesc());
				hmDatosFila.put("numaperturas",
						listadoEstadistica.get(i).getNumAperturas());
				hmDatosFila.put("porcentaje",
						listadoEstadistica.get(i).getPorcentaje());
				hmDatosFila.put("numAperturasAnt",
						listadoEstadistica.get(i).getNumAperturasAnt());
				hmDatosFila.put("porcentajeAnt",
						listadoEstadistica.get(i).getPorcentajeAnt());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoBiAnualMesTer", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(
					new Grupo(this.obtenerListadoBianualMesTerPDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Obtener listado bianual mes ter PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListadoBianualMesTerPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.mes", null, locale),
				"mes", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.territorio", null,
						locale),
				"territorio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturas", null,
						locale),
				"numaperturas", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.porcentaje", null,
						locale),
				"porcentaje", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturasano", null,
						locale),
				"numAperturasAnt", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.porcentaje", null,
						locale),
				"porcentajeAnt", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoAnualSecTer(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		List<ComunicacionApertura> lista = this.comunicacionAperturaDao
				.findListadoAnualSecTer(filtro, jqGridRequestDto, false);

		Long recordNum = this.comunicacionAperturaDao
				.findListadoAnualSecTerCount(
						filtro != null ? filtro : new ComunicacionApertura(),
						false);

		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoAnualMesTerPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoAnualSecTerPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findListadoAnualSecTer(filtro, jqGridRequestDto, false);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {

				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("seccion",
						listadoEstadistica.get(i).getSectorDesc());
				hmDatosFila.put("cnaeCtr",
						listadoEstadistica.get(i).getCnaectr056());
				hmDatosFila.put("cnaeEmp",
						listadoEstadistica.get(i).getCnaeemp056());
				hmDatosFila.put("territorio",
						listadoEstadistica.get(i).getTerapeDesc());
				hmDatosFila.put("numaperturas",
						listadoEstadistica.get(i).getNumAperturas());
				hmDatosFila.put("porcentaje",
						listadoEstadistica.get(i).getPorcentaje());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoAnualSecTer", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(
					new Grupo(this.obtenerListadoAnualSecTerPDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtener listado anual sec ter PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListadoAnualSecTerPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.seccion", null,
						locale),
				"seccion", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.cnaeCtr", null,
						locale),
				"cnaeCtr", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.cnaeEmp", null,
						locale),
				"cnaeEmp", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.territorio", null,
						locale),
				"territorio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturas", null,
						locale),
				"numaperturas", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.porcentaje", null,
						locale),
				"porcentaje", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoSinInfoOsalan(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		List<ComunicacionApertura> lista = this.comunicacionAperturaDao
				.findListadoSinInfoOsalan(filtro, jqGridRequestDto, false);

		Long recordNum = this.comunicacionAperturaDao
				.findListadoSinInfoOsalanCount(
						filtro != null ? filtro : new ComunicacionApertura(),
						false);

		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoSinInfoOsalanPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoSinInfoOsalanPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findListadoSinInfoOsalan(filtro, jqGridRequestDto, false);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {

				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("expediente",
						listadoEstadistica.get(i).getTerape056() + "/"
								+ listadoEstadistica.get(i).getAnoape056() + "/"
								+ listadoEstadistica.get(i).getNumape056());
				hmDatosFila.put("fecpre",
						listadoEstadistica.get(i).getFecpre056() != null
								? Utilities.getInstance()
										.formatearDateIdioma(listadoEstadistica
												.get(i).getFecpre056())
								: "");
				hmDatosFila.put("numdoc",
						listadoEstadistica.get(i).getNumdoc056());
				hmDatosFila.put("nomemp",
						listadoEstadistica.get(i).getNomemp056());
				hmDatosFila.put("prvctr", listadoEstadistica.get(i)
						.getProvinciaCtr().getDescripcion());
				hmDatosFila.put("munctr", listadoEstadistica.get(i)
						.getMunicipioCtr().getDescripcion());
				hmDatosFila.put("dirctr",
						listadoEstadistica.get(i).getDirctr056());
				hmDatosFila.put("visita",
						listadoEstadistica.get(i).getVisita());
				hmDatosFila.put("finfinsp",
						listadoEstadistica.get(i).getFinfinsp056() != null
								? listadoEstadistica.get(i).getFinfinsp056()
										.toString()
								: "");

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoSinInfoOsalan", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(new Grupo(
					this.obtenerListaColumnasSinInfoOsalanPDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;

		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtener lista columnas sin info osalan PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListaColumnasSinInfoOsalanPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.expediente", null,
						locale),
				"expediente", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.fecpre", null, locale),
				"fecpre", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numdoc", null, locale),
				"numdoc", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.nomemp", null, locale),
				"nomemp", Constantes.TRES, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.prvctr", null, locale),
				"prvctr", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.munctr", null, locale),
				"munctr", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.dirctr", null, locale),
				"dirctr", Constantes.TRES, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.visita", null, locale),
				"visita", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.finfinsp", null,
						locale),
				"finfinsp", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoSubsanacion(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		List<ComunicacionApertura> lista = this.comunicacionAperturaDao
				.findListadoSubsanacion(filtro, jqGridRequestDto, false);

		Long recordNum = this.comunicacionAperturaDao
				.findListadoSubsanacionCount(
						filtro != null ? filtro : new ComunicacionApertura(),
						false);

		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoAnualMesTerPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoSubsanacionPDF(ComunicacionApertura filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException {
		try {
			String informe = "";

			String mascara = Utilities.getInstance().getDateMask();

			Format formatter = new SimpleDateFormat(mascara);

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findListadoSubsanacion(filtro, jqGridRequestDto, false);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {

				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("expediente",
						listadoEstadistica.get(i).getTerape056() + "/"
								+ listadoEstadistica.get(i).getAnoape056() + "/"
								+ listadoEstadistica.get(i).getNumape056());
				hmDatosFila.put("fecpre",
						(listadoEstadistica.get(i).getFecpre056() != null)
								? formatter.format(listadoEstadistica.get(i)
										.getFecpre056())
								: "");
				hmDatosFila.put("fecreq",
						(listadoEstadistica.get(i).getFecreq056() != null)
								? formatter.format(listadoEstadistica.get(i)
										.getFecreq056())
								: "");
				hmDatosFila.put("numdoc",
						listadoEstadistica.get(i).getNumdoc056());
				hmDatosFila.put("nomemp",
						listadoEstadistica.get(i).getNomemp056());
				hmDatosFila.put("prvctr", listadoEstadistica.get(i)
						.getProvinciaCtr().getDescripcion());
				hmDatosFila.put("munctr", listadoEstadistica.get(i)
						.getMunicipioCtr().getDescripcion());
				hmDatosFila.put("dirctr",
						listadoEstadistica.get(i).getDirctr056());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoAnualSecTer", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(
					new Grupo(this.obtenerListadoSubsanacionPDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Obtener listado subsanacion PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListadoSubsanacionPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.expediente", null,
						locale),
				"expediente", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.fecpre", null, locale),
				"fecpre", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.fecreq", null, locale),
				"fecreq", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numdoc", null, locale),
				"numdoc", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.nomemp", null, locale),
				"nomemp", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.prvctr", null, locale),
				"prvctr", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.munctr", null, locale),
				"munctr", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.dirctr", null, locale),
				"dirctr", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param b
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoTramosTrabajadores(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b) {

		List<ComunicacionApertura> lista = this.comunicacionAperturaDao
				.findNumberAperturaTrab(filtro, false);

		Long recordNum = (long) lista.size();
		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoTramosTrabajadoresPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoTramosTrabajadoresPDF(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto)
			throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findNumberAperturaTrab(filtro, false);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {
				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("trabajadores",
						listadoEstadistica.get(i).getTipoPart());
				hmDatosFila.put("numAperturas",
						listadoEstadistica.get(i).getNumAperturas());
				hmDatosFila.put("porcentaje",
						listadoEstadistica.get(i).getPorcentaje());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoTramosTrabajadores", null,
							locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(new Grupo(
					this.obtenerListadoTramosTrabajadoresPDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtener listado tramos trabajadores PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListadoTramosTrabajadoresPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.trabajadores", null,
						locale),
				"trabajadores", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturas", null,
						locale),
				"numAperturas", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.porcentaje", null,
						locale),
				"porcentaje", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param b
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterlistadoTramosTrabajadoresPorCentro(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b) {

		List<ComunicacionApertura> lista = this.comunicacionAperturaDao
				.findNumberAperturaTrabPorCentro(filtro, jqGridRequestDto,
						false);
		Long recordNum = this.comunicacionAperturaDao
				.findNumberAperturaTrabPorCentroCount(
						filtro != null ? filtro : new ComunicacionApertura(),
						b);

		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoTramosTrabajadoresPorCentroPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoTramosTrabajadoresPorCentroPDF(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto)
			throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findNumberAperturaTrabPorCentro(filtro, jqGridRequestDto,
							false);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {
				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("territorio",
						listadoEstadistica.get(i).getTerapeDesc());
				hmDatosFila.put("tipoCentro",
						listadoEstadistica.get(i).getDescTipoCtr());
				hmDatosFila.put("numAperturas",
						listadoEstadistica.get(i).getNumAperturas());
				hmDatosFila.put("porcentaje",
						listadoEstadistica.get(i).getPorcentaje());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoTramosTrabajadoresPorCentro",
							null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(new Grupo(
					this.obtenerListadoTramosTrabajadoresPorCentroPDF(),
					"GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtener listado tramos trabajadores por centro PDF.
	 * 
	 * List<DefinicionCol>
	 * 
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListadoTramosTrabajadoresPorCentroPDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.territorio", null,
						locale),
				"territorio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.tipoCtr", null,
						locale),
				"tipoCentro", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturas", null,
						locale),
				"numAperturas", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.porcentaje", null,
						locale),
				"porcentaje", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Filter method in the Ab04b56s00 table.
	 * 
	 * @param filtro
	 *            Ab04b56s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param b
	 *            Boolean JQGridResponseDto<Ab04b56s00>
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionApertura> filterListadoTramosTrabajadoresPorTrab(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto,
			boolean b) {
		List<ComunicacionApertura> lista = new ArrayList<ComunicacionApertura>();

		lista = this.comunicacionAperturaDao
				.findNumberAperturaTrabPorTrabajadores(filtro,
						jqGridRequestDto);

		Long recordNum = this.comunicacionAperturaDao
				.findNumberAperturaTrabPorTrabajadoresCount(
						filtro != null ? filtro : new ComunicacionApertura(),
						jqGridRequestDto);

		return new JQGridResponseDto<ComunicacionApertura>(jqGridRequestDto,
				recordNum, lista);
	}

	/**
	 * filterListadoTramosTrabajadoresPorTrabPDF.
	 * 
	 * @param filtro
	 *            ComunicacionApertura
	 * @param jqGridRequestDto
	 *            JQGridRequestDto String
	 * @return the string
	 * @throws AB04BException
	 *             the exception
	 */
	public String filterListadoTramosTrabajadoresPorTrabPDF(
			ComunicacionApertura filtro, JQGridRequestDto jqGridRequestDto)
			throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<ComunicacionApertura> listadoEstadistica = this.comunicacionAperturaDao
					.findNumberAperturaTrabPorTrabajadores(filtro,
							jqGridRequestDto);

			// if (!listadoEstadistica.isEmpty()) {

			for (int i = 0; i < listadoEstadistica.size(); i++) {
				hmDatosFila = this.inicializarHmDatosFila();

				hmDatosFila.put("territorio",
						listadoEstadistica.get(i).getTerapeDesc());
				hmDatosFila.put("mes", listadoEstadistica.get(i).getMes());
				hmDatosFila.put("tipoPart",
						listadoEstadistica.get(i).getTipoPart());
				hmDatosFila.put("numAperturas",
						listadoEstadistica.get(i).getNumAperturas());

				hmDatos.add(hmDatosFila);
			}
			// }

			DefinicionCab defCab = this.setDefinicionCab(filtro.getTerape056());
			DefinicionPie defPie = null;
			String titulo = "";
			Locale locale = LocaleContextHolder.getLocale();
			defPie = this.setDefinicionPie();
			titulo = this.appMessageSource
					.getMessage("titulo.listadoTramosTrabajadoresPorTrab", null,
							locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerape056() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerape056());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerapeDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			String sel = filtro.getAgrupacion();
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(new Grupo(
					this.obtenerListadoTramosTrabajadoresPorTrabPDF(sel),
					"GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtener listado tramos trabajadores por trab PDF.
	 * 
	 * @param sel
	 *            String List<DefinicionCol>
	 * @return the list
	 */
	private List<DefinicionCol> obtenerListadoTramosTrabajadoresPorTrabPDF(
			String sel) {
		String titCol = "";

		if ("total".equals(sel)) {
			titCol = "titulo.totTrab";
		} else if ("mujeres".equals(sel)) {
			titCol = "titulo.numMuj";
		} else {
			titCol = "titulo.numHom";
		}

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.territorio", null,
						locale),
				"territorio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.mes", null, locale),
				"mes", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage(titCol, null, locale),
				"tipoPart", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.numaperturas", null,
						locale),
				"numAperturas", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	// /**
	// * Paginacion
	// *
	// * @param jqGridRequestDto
	// * JQGridRequestDto
	// * @param results
	// * List<ComunicacionApertura>
	// * JQGridResponseDto<ComunicacionApertura>
	// */
	// private JQGridResponseDto<ComunicacionApertura> paginacion(
	// JQGridRequestDto jqGridRequestDto,
	// List<ComunicacionApertura> results) {
	// if (jqGridRequestDto != null && jqGridRequestDto.getRows() != null) {
	// List<ComunicacionApertura> listadoFinalPaginado = new
	// ArrayList<ComunicacionApertura>();
	//
	// Long rows = jqGridRequestDto.getRows();
	// Long page = jqGridRequestDto.getPage();
	//
	// int inicio = rows.intValue() * (page.intValue() - 1);
	// int fin = rows.intValue() * page.intValue();
	//
	// for (int k = inicio; k < fin; k++) {
	// if (k < results.size()) {
	// listadoFinalPaginado.add(results.get(k));
	// }
	// }
	// return new JQGridResponseDto<ComunicacionApertura>(
	// jqGridRequestDto, (long) results.size(),
	// listadoFinalPaginado);
	// } else {
	// return new JQGridResponseDto<ComunicacionApertura>(
	// jqGridRequestDto, (long) results.size(), results);
	// }
	// }

	/**
	 * Inicializar hm datos fila.
	 * 
	 * HashMap
	 * 
	 * @return the hash map
	 */
	public HashMap<String, String> inicializarHmDatosFila() {
		return new HashMap<String, String>();
	}

	/**
	 * Obtener titulo filtro.
	 * 
	 * @param titulo
	 *            String
	 * @param filtro
	 *            ComunicacionApertura
	 * @param fechaObtencion
	 *            Date String
	 * @return the string
	 */
	private String obtenerTituloFiltro(String titulo,
			ComunicacionApertura filtro, Date fechaObtencion) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuilder tituloConFiltro = new StringBuilder(
				Constantes.TAMANYO_3000);
		String tab = "   ";

		tituloConFiltro.append(titulo);
		tituloConFiltro.append("\n");

		if (filtro.getTerapeDesc() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.territorio", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getTerapeDesc());
		}
		if (filtro.getIndobra056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.obra", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro
					.append(filtro.getIndobra056().equals(Constantes.VALUE_SI)
							? Constantes.TOOLKIT_SI : Constantes.TOOLKIT_NO);
		}
		if (filtro.getAnoape056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.anyo", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getAnoape056());
		}
		if (filtro.getNumExpDesde() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.numexpDesde", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getNumExpDesde());
		}
		if (filtro.getNumExpHasta() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.numexpHasta", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getNumExpHasta());
		}
		if (filtro.getFecpreDesde() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.fecpreDesde", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(Utilities.getInstance()
					.formatearDateIdioma(filtro.getFecpreDesde()));
		}
		if (filtro.getFecpreHasta() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.fecpreHasta", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(Utilities.getInstance()
					.formatearDateIdioma(filtro.getFecpreHasta()));
		}
		if (fechaObtencion != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.fecObtencion", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(Utilities.getInstance()
					.formatearDateIdioma(fechaObtencion));
		}
		if (filtro.getTipdoc056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.numdoc", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro
					.append(filtro.getTipdoc056().equals(Constantes.TIPO_CIF)
							? Constantes.CIF
							: filtro.getTipdoc056().equals(Constantes.TIPO_NIF)
									? Constantes.NIF : Constantes.OTROS);
		}
		if (filtro.getNumdoc056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.numeroDocumento", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getNumdoc056());
		}
		if (filtro.getPlanseg056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.planSg056", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro
					.append(filtro.getPlanseg056().equals(Constantes.VALUE_SI)
							? Constantes.TOOLKIT_SI : Constantes.TOOLKIT_NO);
		}
		if (filtro.getProytec056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.proyectoTecnico056", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro
					.append(filtro.getProytec056().equals(Constantes.VALUE_SI)
							? Constantes.TOOLKIT_SI : Constantes.TOOLKIT_NO);
		}
		if (filtro.getApdoanx056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.apdoAnexo056", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro
					.append(filtro.getApdoanx056().equals(Constantes.VALUE_SI)
							? Constantes.TOOLKIT_SI : Constantes.TOOLKIT_NO);
		}
		if (filtro.getTipoApertura() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.tipoape", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getTipoApertura().getDesapeEs071());
		}
		if (filtro.getPaisemp056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.paisemp", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getPaisemp056());
		}
		if (filtro.getProvinciaEmp() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.teremp", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(Utilities.getInstance()
					.strTerritorio(filtro.getProvinciaEmp().getCodProvincia()));
		}
		if (filtro.getMunicipioEmp() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.teremp", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getMunicipioEmp().getDescripcion());
		}
		if (filtro.getProvinciaCtr() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.terctr", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(Utilities.getInstance()
					.strTerritorio(filtro.getProvinciaCtr().getCodProvincia()));
		}
		if (filtro.getMunicipioCtr() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.terctr", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getMunicipioCtr().getCodMunicipio());
		}
		if (filtro.getCnaectr056() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.cnaeCtr", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getCnaectr056());
		}
		if (filtro.getDescVisosl() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("label.visOsalan056", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getDescVisosl());
		}
		if (filtro.getIndInfInsp() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.tieneinformeinsp", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro
					.append(filtro.getIndInfInsp().equals(Constantes.VALUE_SI)
							? Constantes.TOOLKIT_SI : Constantes.TOOLKIT_NO);
		}

		return tituloConFiltro.toString();
	}

	/**
	 * MÃ©todo para crear la definiciÃ³n de la cabecera (Zona zona1, Zona zona2,
	 * Zona zona3, Integer tam), las zonas (String tipo, Elemento elemento,
	 * String alineacion) y los elementos (String text, byte[] img).
	 * 
	 * @param territorio
	 *            String DefinicionCab
	 * @return the definicion cab
	 * @throws AB04BException
	 *             Exception
	 */
	private DefinicionCab setDefinicionCab(String territorio)
			throws AB04BException {
		// try {
		Locale locale = LocaleContextHolder.getLocale();

		// String codDelegacion = K72BXLNetUtils.dameDelegacion();
		// String file =
		// this.appConfiguration.getProperty("ruta.imagen".concat(codDelegacion));
		String file = "";
		if (territorio != null) {
			file = this.appConfiguration
					.getProperty("ruta.imagen".concat(territorio));
		} else {
			file = this.appConfiguration
					.getProperty("ruta.imagen".concat(Constantes.TH_TODOS));
		}

		ComunicacionAperturaServiceImpl.logger.info("ruta imagen::: " + file);
		ByteArrayOutputStream ous = null;
		// InputStream ios = null;
		FileInputStream ios = null;
		try {
			byte[] buffer = new byte[Constantes.STRING_BUILDER_INIT];
			ous = new ByteArrayOutputStream();
			ComunicacionAperturaServiceImpl.logger
					.info("buffer imagen::: " + buffer);
			ios = new FileInputStream(file);
			ComunicacionAperturaServiceImpl.logger.info("ios imagen::: " + ios);
			int read = 0;
			try {
				ComunicacionAperturaServiceImpl.logger
						.info("antes del while recorre imagen");
				while ((read = ios.read(buffer)) != -1) {
					ComunicacionAperturaServiceImpl.logger
							.info("dentro del while recorre imagen" + read);
					ous.write(buffer, 0, read);
				}
			} catch (IOException e) {
				throw new AB04BException(e, e.getMessage());
			} finally {
				try {
					if (ios != null) {
						ios.close();
					}
				} catch (IOException e) {
					ComunicacionAperturaServiceImpl.logger
							.error("ERROR en setDefinicionCab", e);
				}
			}

			byte[] img = ous.toByteArray();

			Date now = new Date();

			String s1 = Utilities.getInstance().formatearDateIdioma(now);

			// DefinicionCab
			return new DefinicionCab(
					new Zona(Tipo.TEXTO,
							new Elemento(
									this.appMessageSource
											.getMessage("titulo.aplicacion",
													null, locale)
											.toUpperCase(),
									null),
							AlineacionZona.CENTRO),
					new Zona(Tipo.IMAGEN, new Elemento(null, img),
							AlineacionZona.CENTRO),
					new Zona(
							Tipo.TEXTO, new Elemento(
									this.appMessageSource
											.getMessage("titulo.fecha", null,
													locale)
											.toUpperCase().concat(" ")
											.concat(s1),
									null),
							AlineacionZona.CENTRO),
					Constantes.CIENTO_TREINTA);
		} catch (IOException e) {
			throw new AB04BException(e, e.getMessage());
		} finally {
			try {
				if (ous != null) {
					ous.close();
				}

				if (ios != null) {
					ios.close();
				}
			} catch (IOException e) {
				ComunicacionAperturaServiceImpl.logger
						.error("ERROR en setDefinicionCab", e);
			}
		}
		// } catch (Exception e) {
		// throw new AB04BException(e, e.getMessage());
		// }
	}

	/**
	 * MÃ©todo para crear la definiciÃ³n del pie de pÃ¡gina (String text1,
	 * String text2, String text3, Integer tam).
	 * 
	 * DefinicionPie
	 * 
	 * @return the definicion pie
	 * @throws AB04BException
	 *             Exception
	 */
	private DefinicionPie setDefinicionPie() throws AB04BException {
		try {

			// String tituloDes =
			// this.k72CrearXMLInformeService.devolverPiePagina();
			String tituloDes = "";
			return new DefinicionPie("", tituloDes, "numpag", Constantes.CIEN);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * MÃ©todo para crear la definiciÃ³n de la pÃ¡gina (String orientacion,
	 * Integer tamanoLetra, String tamanoPag, String textoAdicional).
	 * 
	 * @param titulo
	 *            String DefinicionPag
	 * @return the definicion pag
	 */
	private DefinicionPag setDefinicionPag(String titulo) {
		return new DefinicionPag(Orientacion.HORIZONTAL,

				Constantes.DIEZ, Tamano.A4, titulo);
	}

	/**
	 * MÃ©todo para convertir la lista de Datos antes creada a un String y
	 * pasarlo como JSON a el web service.
	 * 
	 * @param listaInforme
	 *            List<HashMap<String, String>> String
	 * @return the string
	 * @throws JsonGenerationException
	 *             JsonGenerationException
	 * @throws JsonMappingException
	 *             JsonMappingException
	 * @throws IOException
	 *             IOException
	 */
	private String convertirJson(List<HashMap<String, String>> listaInforme)
			throws JsonGenerationException, JsonMappingException, IOException {

		String json = null;
		ObjectMapper objMapper = new ObjectMapper();
		json = objMapper.writeValueAsString(listaInforme);

		return json;
	}

	/**
	 * MÃ©todo para convertir la lista de Grupos antes creada a un String y
	 * pasarlo como JSON a el web service.
	 * 
	 * @param listaGrupos
	 *            List<Grupo> String
	 * @return the string
	 * @throws JsonGenerationException
	 *             JsonGenerationException
	 * @throws JsonMappingException
	 *             JsonMappingException
	 * @throws IOException
	 *             IOException
	 */
	private String convertirJsonGr(List<Grupo> listaGrupos)
			throws JsonGenerationException, JsonMappingException, IOException {

		String json = null;
		ObjectMapper objMapper = new ObjectMapper();
		json = objMapper.writeValueAsString(listaGrupos);

		return json;
	}

	/**
	 * Obtener documentos migrados.
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the folder document list
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ComunicacionAperturaService#
	 * obtenerDocumentosMigrados(java.lang.String)
	 */
	@Override()
	public FolderDocumentList obtenerDocumentosMigrados(String folderId) {
		return reeService.obtenerDocumentosMigrados(folderId);
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * @param ab04b56s00
	 *            Ab04b56s00
	 * @param updateFecRecInspecc
	 *            updateFecRecInspecc Ab04b56s00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateFecInspeccion(
			ComunicacionApertura ab04b56s00, boolean updateFecRecInspecc) {

		return this.comunicacionAperturaDao.updateFecInspeccion(ab04b56s00,
				updateFecRecInspecc);
	}

	/**
	 * Update cierre temporal.
	 * 
	 * @param apertura
	 *            the apertura
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.ComunicacionAperturaService#updateCierreTemporal
	 * (com.ejie.ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public void updateCierreTemporal(ComunicacionApertura apertura) {
		this.comunicacionAperturaDao.updateCierreTemporal(apertura);
	}

	/**
	 * Update fec fin plazo.
	 * 
	 * @param apertura
	 *            the apertura
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.ComunicacionAperturaService#updateFecFinPlazo(
	 * com.ejie.ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public void updateFecFinPlazo(ComunicacionApertura apertura) {
		this.comunicacionAperturaDao.updateFecFinPlazo(apertura);

	}

	/**
	 * Update usuarios tramitacion.
	 * 
	 * @param apertura
	 *            the apertura
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ComunicacionAperturaService#
	 * updateUsuariosTramitacion (com.ejie.ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public void updateUsuariosTramitacion(ComunicacionApertura apertura) {
		this.comunicacionAperturaDao.updateUsuariosTramitacion(apertura);

	}

	/**
	 * Find last S sof num doc.
	 * 
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.ComunicacionAperturaService#findLastSSofNumDoc
	 * (com.ejie.ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public ComunicacionApertura findLastSSofNumDoc(
			ComunicacionApertura filtro) {
		return this.comunicacionAperturaDao.findLastSSofNumDoc(filtro);
	}

	/**
	 * Find last RE aof num doc.
	 * 
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.ComunicacionAperturaService#findLastREAofNumDoc
	 * (com.ejie.ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public ComunicacionApertura findLastREAofNumDoc(
			ComunicacionApertura filtro) {
		return this.comunicacionAperturaDao.findLastREAofNumDoc(filtro);
	}

	/**
	 * Valida que el CP pertenezca a la localidad.
	 * 
	 * @param comunicacionApertura
	 *            ComunicacionApertura
	 * @return boolean
	 */
	public boolean validaLocalidadCP(
			ComunicacionApertura comunicacionApertura) {

		Long recordNum = this.comunicacionAperturaDao
				.findCPenLocalidadCount(comunicacionApertura);

		return recordNum > 0;

	}

	@Override
	public void updateBatchSub(ComunicacionApertura apertura) {
		this.comunicacionAperturaDao.updateBatchSub(apertura);

	}

	@Override
	public void modificarIndObra(ComunicacionApertura comunicacionApertura) {

		if ("S".equals(comunicacionApertura.getIndobra056())) {
			comunicacionApertura = this.vFind(comunicacionApertura);
			if (comunicacionApertura.getCodobra056() == null) {
				Obra obra = new Obra();
				obra.setAnoexp082(comunicacionApertura.getAnoape056());
				obra.setNumexp082(
						comunicacionApertura.getNumape056().intValue());
				obra.setTerexp082(comunicacionApertura.getTerape056());
				// Si es de obra, insertamos la obra
				comunicacionApertura.setObra(this.obraDao.addPresencial(obra));
				comunicacionApertura.setCodobra056(
						comunicacionApertura.getObra().getCodobra082());

				this.comunicacionAperturaDao
						.updateCodObra(comunicacionApertura);
			}

		}

	}

	@Override
	public void updateFecSub(ComunicacionApertura apertura) {
		this.comunicacionAperturaDao.updateFecSub(apertura);

	}
}
